connect island 1 sysadm/sysadm;
update statistics on database;
commit;

connect island 1 fkb/fkb;
commit;

-- Some DML operations followed by a rollback
delete from invoice_item;
delete from invoice;
update inventory set warehouse = 'MAIN'; 
rollback;

-- Connect a few more handles as different users
connect island 2 hpg/hpg;
commit;
connect island 3 hpg/hpg;
commit;
connect island 4 sdj/sdj;
commit;
connect island 5 ctl/ctl;
commit;
connect island 6 rbp/rbp;
commit;
connect island 7 rbp/rbp;
commit;
connect island 8 hpg/hpg;
commit;
connect island 9 fkb/fkb;
commit;
connect island 10 fkb/fkb;
commit;
connect island 11 rbp/rbp;
commit;
connect island 12 rbp/rbp;
commit;
connect island 13 rbp/rbp;
commit;
set isolation rl;

use 1;
prepare
SELECT c.Company_Name, SUM(Item_Price * Quantity) -
	@NullValue(SUM(i.Amount_Paid)/COUNT(i.Invoice_No), 0) AS Owing
FROM	INVOICE i, INVOICE_ITEM ii, COMPANY c
WHERE	c.Company_ID = i.Company_ID
AND	i.Invoice_No = ii.Invoice_No
GROUP BY 1;

use 2;
prepare SELECT * FROM Company;

use 3;
SELECT Count(*)
FROM Invoice;

use 4;
prepare
UPDATE Invoice
SET Status = 'LATE'
WHERE Status NOT IN ('LATE', 'CANCELLED')
AND Invoice_Date < SysDateTime - 30;

use 5;
SELECT Count(*) from Invoice_Item;

use 6;
UPDATE Budget
SET MONTH_01 = MONTH_01;

use 7;
prepare SELECT Style_ID, Description FROM Product;
perform;
fetch 3;

use 8;
UPDATE DB_INFO
SET Sys_Color = Sys_Color;

use 10;
prepare
SELECT c.Company_Name, 
              SUM( @Decode( i.Status, 'PAID', Item_Price, 0 ) * Quantity ) AS "Paid",
              SUM( @Decode( i.Status, 'LATE', Item_Price, 0 ) * Quantity ) AS "Late",
              SUM( @Decode( i.Status, 'OPEN', Item_Price, 0 ) * Quantity ) AS "Open",
              SUM( @Decode( i.Status, 'CANCELLED', Item_Price, 0 ) * Quantity ) AS "Cancelled"
FROM Company c, Invoice i, Invoice_Item ii
WHERE i.Company_Id = c.Company_Id
AND i.Invoice_No = ii.Invoice_No
GROUP BY 1;

-- End of script --
